# Quick test of backend API
Write-Host "Testing backend at http://localhost:4000...`n" -ForegroundColor Cyan

# Test 1: Health check
Write-Host "[1] Testing /health endpoint..." -ForegroundColor Yellow
try {
    $health = Invoke-RestMethod -Uri "http://localhost:4000/health" -TimeoutSec 3
    Write-Host "✓ Health check passed: $($health.service)`n" -ForegroundColor Green
} catch {
    Write-Host "✗ Health check failed: $($_.Exception.Message)`n" -ForegroundColor Red
    exit 1
}

# Test 2: Register with role
Write-Host "[2] Testing /api/auth/register with role=student..." -ForegroundColor Yellow
try {
    $body = @{
        fullName = "Test Student"
        email = "student-test@example.com"
        password = "testpass123"
        role = "student"
    } | ConvertTo-Json
    
    $reg = Invoke-RestMethod -Method Post -Uri "http://localhost:4000/api/auth/register" -ContentType "application/json" -Body $body
    Write-Host "✓ Registration successful!" -ForegroundColor Green
    Write-Host "  Email: $($reg.user.email)" -ForegroundColor Gray
    Write-Host "  Role: $($reg.user.role)" -ForegroundColor Gray
    Write-Host "  Token: $($reg.token.Substring(0,30))...`n" -ForegroundColor Gray
} catch {
    $errMsg = $_.Exception.Message
    if ($errMsg -match "409|already exists") {
        Write-Host "✓ Registration endpoint working (user already exists)`n" -ForegroundColor Green
    } else {
        Write-Host "✗ Registration failed: $errMsg`n" -ForegroundColor Red
    }
}

# Test 3: Login with role check
Write-Host "[3] Testing /api/auth/login with role verification..." -ForegroundColor Yellow
try {
    $body = @{
        email = "student-test@example.com"
        password = "testpass123"
        role = "student"
    } | ConvertTo-Json
    
    $login = Invoke-RestMethod -Method Post -Uri "http://localhost:4000/api/auth/login" -ContentType "application/json" -Body $body
    Write-Host "✓ Login successful!" -ForegroundColor Green
    Write-Host "  User: $($login.user.fullName) ($($login.user.role))`n" -ForegroundColor Gray
} catch {
    Write-Host "✗ Login failed: $($_.Exception.Message)`n" -ForegroundColor Red
}

Write-Host "All tests completed!" -ForegroundColor Cyan
