export function warnError(context, err, extra) {
  try {
    if (err && typeof err === "object") {
      try {
        err._warnLogged = true;
      } catch (_markErr) {
        // ignore
      }
    }

    const status = typeof err?.status === "number" ? err.status : undefined;
    const message = err?.message || String(err);

    // eslint-disable-next-line no-console
    console.warn(`[WARN] ${context}`, {
      status,
      message,
      ...(extra ? { extra } : {}),
      ...(err?.stack ? { stack: err.stack } : {}),
    });
  } catch (_loggingErr) {
    // eslint-disable-next-line no-console
    console.warn(`[WARN] ${context}`);
  }
}
