import { warnError } from "./log.js";

export function notFound(_req, res) {
  res.status(404).json({ error: "Not found" });
}

export function errorHandler(err, _req, res, _next) {
  const status = typeof err?.status === "number" ? err.status : 500;
  const message = err?.message || "Server error";

  warnError("http.errorHandler", err, { status, message });

  res.status(status).json({ error: message });
}

export function httpError(status, message) {
  const err = new Error(message);
  err.status = status;
  return err;
}
