import express from "express";

import { authRouter } from "./modules/auth/auth.router.js";
import { usersRouter } from "./modules/users/users.router.js";
import { attendanceRouter } from "./modules/attendance/attendance.router.js";
import { projectsRouter } from "./modules/projects/projects.router.js";
import { todosRouter } from "./modules/todos/todos.router.js";
import { chatRouter } from "./modules/chat/chat.router.js";
import { announcementsRouter } from "./modules/announcements/announcements.router.js";
import { leaveRouter } from "./modules/leave/leave.router.js";
import { ticketsRouter } from "./modules/tickets/tickets.router.js";
import { notificationsRouter } from "./modules/notifications/notifications.router.js";

export const apiRouter = express.Router();

apiRouter.use("/auth", authRouter);
apiRouter.use("/users", usersRouter);
apiRouter.use("/attendance", attendanceRouter);
apiRouter.use("/projects", projectsRouter);
apiRouter.use("/todos", todosRouter);
apiRouter.use("/chat", chatRouter);
apiRouter.use("/announcements", announcementsRouter);
apiRouter.use("/leave", leaveRouter);
apiRouter.use("/tickets", ticketsRouter);
apiRouter.use("/notifications", notificationsRouter);
