import { z } from "zod";

const categorySchema = z.enum([
  "graphics-design",
  "web-development",
  "ui-ux-design",
  "digital-marketing",
  "video-production",
  "general",
]);

export const createUserSchema = z.object({
  body: z.object({
    fullName: z.string().min(2),
    email: z.string().email(),
    phone: z.string().min(7).max(25).optional(),
    password: z.string().min(8),
    role: z.enum(["admin", "employee", "intern", "student", "customer"]),
    category: categorySchema.optional(),
  }),
});

export const updateMeSchema = z.object({
  body: z
    .object({
      fullName: z.string().min(2).optional(),
      phone: z.string().min(7).max(25).optional(),
      category: categorySchema.optional(),
      avatarUrl: z.string().min(1).max(1_500_000).optional(),
    })
    .refine((b) => Object.keys(b).length > 0, {
      message: "At least one field is required",
    }),
});

export const updateUserStatusSchema = z.object({
  params: z.object({ id: z.string().min(1) }),
  body: z.object({ status: z.enum(["pending", "active", "disabled"]) }),
});

export const updateUserCategorySchema = z.object({
  params: z.object({ id: z.string().min(1) }),
  body: z.object({ category: categorySchema }),
});
