import mongoose from "mongoose";

const userSchema = new mongoose.Schema(
  {
    fullName: { type: String, required: true, trim: true },
    phone: { type: String, trim: true },
    email: {
      type: String,
      required: true,
      unique: true,
      lowercase: true,
      trim: true,
    },
    passwordHash: { type: String, required: true },
    role: {
      type: String,
      enum: ["admin", "employee", "intern", "student", "customer"],
      required: true,
      index: true,
    },
    status: {
      type: String,
      enum: ["pending", "active", "disabled"],
      default: "active",
      index: true,
    },
    category: {
      type: String,
      enum: [
        "graphics-design",
        "web-development",
        "ui-ux-design",
        "digital-marketing",
        "video-production",
        "general",
      ],
      default: "general",
      index: true,
    },
    avatarUrl: { type: String, trim: true },

    // Expo push tokens (for device notifications)
    expoPushTokens: {
      type: [String],
      default: [],
    },

    // Password reset
    passwordResetTokenHash: { type: String },
    passwordResetTokenExpiresAt: { type: Date },
  },
  { timestamps: true }
);

export const User = mongoose.model("User", userSchema);
