import { z } from "zod";

export const createTodoSchema = z.object({
  body: z.object({
    title: z.string().min(2),
    description: z.string().max(2000).optional(),
    dueAt: z.string().datetime().optional(),
    projectId: z.string().min(1).optional(),
    assignedTo: z.string().min(1).optional(),
  }),
});

export const updateTodoSchema = z.object({
  params: z.object({ id: z.string().min(1) }),
  body: z.object({
    title: z.string().min(2).optional(),
    description: z.string().max(2000).optional(),
    status: z.enum(["open", "in-progress", "done"]).optional(),
    dueAt: z.string().datetime().nullable().optional(),
  }),
});

export const todoIdParamSchema = z.object({
  params: z.object({
    id: z.string(),
  }),
});
