import { z } from "zod";

export const createTicketSchema = z.object({
  body: z.object({
    title: z.string().min(2).max(120),
    description: z.string().max(5000).optional(),
  }),
});

export const ticketIdParamSchema = z.object({
  params: z.object({ id: z.string().min(1) }),
});

export const updateTicketSchema = z.object({
  params: z.object({ id: z.string().min(1) }),
  body: z
    .object({
      status: z.enum(["open", "in-progress", "closed"]).optional(),
      assignedTo: z.string().min(1).nullable().optional(),
    })
    .refine((b) => Object.keys(b).length > 0, {
      message: "At least one field is required",
    }),
});
