import { z } from "zod";

export const createProjectSchema = z.object({
  body: z.object({
    name: z.string().min(2),
    description: z.string().max(2000).optional(),
    category: z
      .enum([
        "graphics-design",
        "web-development",
        "ui-ux-design",
        "digital-marketing",
        "video-production",
        "general",
      ])
      .optional()
      .default("general"),
    memberIds: z.array(z.string().min(1)).optional(),
    priority: z.enum(["low", "medium", "high", "urgent"]).optional(),
    deadline: z.string().optional(),
    startDate: z.string().optional(),
    tags: z.array(z.string()).optional(),
  }),
});

export const updateProjectSchema = z.object({
  params: z.object({ id: z.string().min(1) }),
  body: z.object({
    name: z.string().min(2).optional(),
    description: z.string().max(2000).optional(),
    category: z
      .enum([
        "graphics-design",
        "web-development",
        "ui-ux-design",
        "digital-marketing",
        "video-production",
        "general",
      ])
      .optional(),
    status: z.enum(["open", "in-progress", "revise", "close"]).optional(),
    priority: z.enum(["low", "medium", "high", "urgent"]).optional(),
    memberIds: z.array(z.string().min(1)).optional(),
    deadline: z.string().optional(),
    startDate: z.string().optional(),
    progress: z.number().min(0).max(100).optional(),
    tags: z.array(z.string()).optional(),
  }),
});

export const createReportSchema = z.object({
  params: z.object({ projectId: z.string().min(1) }),
  body: z.object({
    title: z.string().min(2).max(200),
    description: z.string().min(10).max(5000),
    hoursSpent: z.number().min(0).optional(),
    completionPercentage: z.number().min(0).max(100).optional(),
  }),
});

export const reviewReportSchema = z.object({
  params: z.object({ reportId: z.string().min(1) }),
  body: z.object({
    status: z.enum(["reviewed", "approved", "needs-revision"]),
    reviewNote: z.string().max(1000).optional(),
  }),
});
