import { z } from "zod";

export const listNotificationsSchema = z.object({
  query: z.object({
    limit: z.coerce.number().int().min(1).max(100).default(50),
  }),
});

export const markNotificationReadSchema = z.object({
  params: z.object({
    id: z.string().min(1),
  }),
});

export const registerPushTokenSchema = z.object({
  body: z.object({
    expoPushToken: z.string().min(1),
  }),
});
