import { z } from "zod";

export const createLeaveSchema = z.object({
  body: z.object({
    fromDate: z.string().min(10).max(10),
    toDate: z.string().min(10).max(10),
    reason: z.string().min(2).max(2000),
  }),
});

export const decideLeaveSchema = z.object({
  params: z.object({ id: z.string().min(1) }),
  body: z.object({
    status: z.enum(["approved", "rejected"]),
  }),
});
