import mongoose from "mongoose";

const attendancePolicySchema = new mongoose.Schema(
  {
    key: { type: String, required: true, unique: true },
    weekdayStart: { type: String, required: true, default: "10:00" },
    weekdayEnd: { type: String, required: true, default: "18:00" },
    fridayStart: { type: String, required: true, default: "09:00" },
    fridayEnd: { type: String, required: true, default: "15:00" },
    saturdayOff: { type: Boolean, required: true, default: true },
    freeAbsencesPerMonth: { type: Number, required: true, default: 2 },
  },
  { timestamps: true }
);

export const AttendancePolicy = mongoose.model(
  "AttendancePolicy",
  attendancePolicySchema
);

export async function getAttendancePolicy() {
  const key = "default";
  const existing = await AttendancePolicy.findOne({ key }).lean();
  if (existing) return existing;

  const created = await AttendancePolicy.create({ key });
  return created.toObject();
}
