import { z } from "zod";

const attachmentSchema = z.object({
  filename: z.string().min(1).max(255).optional(),
  url: z.string().min(1).max(2048),
  type: z.enum(["image", "file"]).optional(),
  mimeType: z.string().min(1).max(255).optional(),
  size: z.number().int().nonnegative().optional(),
});

export const createAnnouncementSchema = z.object({
  body: z.object({
    title: z.string().min(2).max(200),
    body: z.string().min(2).max(10000),
    audienceRoles: z
      .array(z.enum(["admin", "employee", "intern", "student", "customer"]))
      .optional(),
    attachments: z.array(attachmentSchema).max(10).optional(),
  }),
});
