import mongoose from "mongoose";

const attachmentSchema = new mongoose.Schema(
  {
    filename: { type: String, trim: true },
    url: { type: String, trim: true },
    type: { type: String, enum: ["image", "file"], default: "file" },
    mimeType: { type: String, trim: true },
    size: { type: Number },
  },
  { _id: false }
);

const announcementSchema = new mongoose.Schema(
  {
    title: { type: String, required: true, trim: true },
    body: { type: String, required: true, trim: true },
    createdBy: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "User",
      required: true,
    },
    audienceRoles: [
      {
        type: String,
        enum: ["admin", "employee", "intern", "student", "customer"],
      },
    ],

    attachments: { type: [attachmentSchema], default: [] },
  },
  { timestamps: true }
);

export const Announcement = mongoose.model("Announcement", announcementSchema);
