# Somarjun Tech company - Office Management Backend

## Setup

1. Copy `.env.example` to `.env` and fill values.
2. Install deps: `npm install`
3. Run: `npm run dev`

## Bootstrap (first time)

- Create the first admin user: `POST /api/auth/seed-admin`
- Then login: `POST /api/auth/login`
- As admin, create employees/interns/students: `POST /api/users`

## Endpoints

- Health

  - `GET /health`

- Auth

  - `POST /api/auth/seed-admin`
  - `POST /api/auth/login`
  - `POST /api/auth/forgot-password`
  - `POST /api/auth/reset-password`

- Users (admin)

  - `GET /api/users`
  - `POST /api/users`
  - `PATCH /api/users/:id/status`

- Attendance

  - `POST /api/attendance/check-in`
  - `POST /api/attendance/check-out`
  - `GET /api/attendance/me`

- Todos

  - `GET /api/todos/me`
  - `POST /api/todos`
  - `PATCH /api/todos/:id`

- Projects

  - `GET /api/projects`
  - `POST /api/projects`
  - `PATCH /api/projects/:id`

- Chat

  - `GET /api/chat/channels`
  - `POST /api/chat/channels`
  - `GET /api/chat/channels/:channelId/messages`
  - `POST /api/chat/channels/:channelId/messages`

- Announcements

  - `GET /api/announcements`
  - `POST /api/announcements` (admin)

- Leave
  - `GET /api/leave/me`
  - `POST /api/leave`
  - `GET /api/leave` (admin)
  - `PATCH /api/leave/:id/decide` (admin)
